IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Contrato_Facturar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Contrato_Facturar
END
GO

CREATE  PROCEDURE [dbo].[CPJ_Contrato_Facturar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 


/*
 * LOG VERSIONES:
 * 13/09/2021: Se agrego Log de Versiones
 * 05/05/2022: Apertura de Items por campo Productos.Flag_Mes_Desglo para 3.1) Por Contratos_Tipos_Prod, 3.2) Por Contratos_Prod
 * 05/05/2022: @Ult_Fecha_Fact_Contrato Se cambia I.Fecha_QA por C.Fecha
 * 16/06/2022: Se optimizan consultas
 * 27/03/2024: Se agrego que tome en cuenta el parametro de agrupar en el titular al facturar los remitos (antes siempre lo agrupaba)
*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Contrato			INT
DECLARE @pId_Usuario			SMALLINT
DECLARE @pFecha					DATETIME
DECLARE @pLote					VARCHAR(20)
DECLARE @pFecha_QA				DATETIME
DECLARE @pFecha_Venc			DATETIME
DECLARE @pFecha_Rem_Desde		DATETIME
DECLARE @pFecha_Rem_Hasta		DATETIME
DECLARE @pRegistrar_Errores		TINYINT
DECLARE @pOmitir_Resultado_OK   TINYINT
DECLARE @pId_Tiempo             CHAR(3)
DECLARE @pRefacturar            TINYINT
DECLARE @pFlag_Tabla_Temp       TINYINT
DECLARE @pIncl_Cbtes_Cero       TINYINT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pOmitir_Resultado_Ok		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')), 0)
SET @pId_Tiempo	            	= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Tiempo')), '')
SET @pRefacturar		        = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Refacturar')), 0)
SET @pId_Contrato				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Contrato')), 0)
SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')),GETDATE())
SET @pLote						= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pFecha_QA					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_QA')),GETDATE())
SET @pFecha_Venc				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Venc')),GETDATE())
SET @pFecha_Rem_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Rem_Desde')),GETDATE())
SET @pFecha_Rem_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Rem_Hasta')),GETDATE())
SET @pRegistrar_Errores			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Registrar_Errores')), 0)
SET @pFlag_Tabla_Temp           = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Tabla_Temp')), 0)
SET @pIncl_Cbtes_Cero           = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Incl_Cbtes_Cero')), 0)

/*FIN Variables recibidas por parametro a traves del JSON*/


/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado TABLE (ErrorNumber	INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(4000))
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)

SET @rtaErrorStored = 0
/*FIN Variable de Retorono del Stored*/


/*Declaracion de Variables*/
DECLARE @Id_Trans							INT
DECLARE @Id_Cliente							INT
DECLARE @Id_Cliente_Remito					INT								  
DECLARE @Id_Tipo_Cbte						CHAR(4)
DECLARE @Id_Cond_Pago						SMALLINT
DECLARE @Id_Moneda							CHAR(3)
DECLARE @Cotizacion							DECIMAL(12, 4)
DECLARE @Plazo_Venc							SMALLINT
DECLARE @FechaVence							DATETIME
DECLARE @Id_Tipo_Con						SMALLINT
DECLARE @Id_Producto						VARCHAR(14)
DECLARE @Cantidad							DECIMAL(15,5)
DECLARE @Cant_Cuotas						SMALLINT
DECLARE @Bonif								DECIMAL(5,2)
DECLARE @Porc_Iva							DECIMAL(5,2)
DECLARE @Precio_Grav						DECIMAL(15,5)
DECLARE @Precio_Exen						DECIMAL(15,5)
DECLARE @Flag_Agru_Cli_Ref					TINYINT
DECLARE @Id_Cliente_Integ					INT
DECLARE @Observacion_Incluye_Integ			VARCHAR(8000)
DECLARE	@Compromete_Factura					SMALLINT
DECLARE	@Compromete_Remitos					SMALLINT
DECLARE @Flag_Remitos						TINYINT
DECLARE @Id_Tipo_Cbte_Remito				CHAR(4)
DECLARE @Fecha_QA							DATETIME
DECLARE @Fecha_Venc							DATETIME
DECLARE @Id_Trans_Remito					INT
DECLARE @TotalCbte							DECIMAL(15,2)
DECLARE @BonifContInt						DECIMAL(5,2)
DECLARE @Bonif_Contrato						DECIMAL(5,2)
DECLARE @Id_Producto_Bonif					VARCHAR(14)
DECLARE @Imp_Bonif_Contrato					DECIMAL(15,2)
DECLARE @Flag_Fact_Titular					TINYINT
DECLARE @Id_Cliente_Ref						INT
DECLARE @CF_Produc_Precio_TipoRespuesta		CHAR(1)
DECLARE @Flag_Mes_Desglo					TINYINT		--05/05/2022 Se agrega para desglozar items de meses
DECLARE @Desglozar_Contador					INT
DECLARE @Desglozar_Fecha_QA					DATETIME
DECLARE @Desglozar_Fecha_Venc				DATETIME
DECLARE @Id_Lista_Precio_Cont				INT
DECLARE @Id_Lista_Precio_Cli_Esp			INT
DECLARE @Id_Lista_Precio_Cli				INT
DECLARE @Id_Lista_Precio					INT
DECLARE @pFlag_Verif_Prod_Fact_x_Contrato	TINYINT	

SET @Id_Lista_Precio = 0

/*FIN Declaracion de Variables*/

SET @Observacion_Incluye_Integ = ''

IF @pFlagUsarTrans <> 0  AND @@TRANCOUNT > 0
	SET @pFlagUsarTrans = 0


BEGIN TRY
	
	IF @pFlagUsarTrans <> 0  
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'Ingreso a Stored Procedure: CPJ_Contrato_Facturar'
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'Parametros:'
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@pId_Contrato: ' + CONVERT(VARCHAR(10), @pId_Contrato)
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': '	+ '@pOmitir_Resultado_Ok: ' + CONVERT(VARCHAR(10), @pOmitir_Resultado_Ok)
															+ '. @pId_Tiempo: ' + CONVERT(VARCHAR(10), @pId_Tiempo)
															+ '. @pRefacturar: ' + CONVERT(VARCHAR(10), @pRefacturar)
															+ '. @pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario)
															+ '. @pFecha: ' + CONVERT(VARCHAR(10), @pFecha, 121) 
															+ '. @pLote: ' + @pLote
															+ '. @pFecha_QA: ' + CONVERT(VARCHAR(10), @pFecha_QA, 121)
															+ '. @pFecha_Venc: ' + CONVERT(VARCHAR(10), @pFecha_Venc, 121)
															+ '. @pFecha_Rem_Desde: ' + CONVERT(VARCHAR(10), @pFecha_Rem_Desde, 121)
															+ '. @pFecha_Rem_Hasta: ' + CONVERT(VARCHAR(10), @pFecha_Rem_Hasta, 121)
															+ '. @pRegistrar_Errores: ' + CONVERT(VARCHAR(10), @pRegistrar_Errores)
															+ '. @pFlag_Tabla_Temp: ' + CONVERT(VARCHAR(10), @pFlag_Tabla_Temp)
															+ '. @pIncl_Cbtes_Cero: ' + CONVERT(VARCHAR(10), @pIncl_Cbtes_Cero)
	END

	/*===================================================================*/	
	
    SELECT  @Id_Cliente = ISNULL(Id_Cliente, 0)
				FROM Contratos 
				WHERE 
				Id_Contrato			= @pId_Contrato

 	IF @pFlag_Tabla_Temp = 0
	   BEGIN

			IF OBJECT_ID (N'Z_CONTRATOS_FACTURADOS', N'U') IS NOT NULL
			   DROP TABLE Z_CONTRATOS_FACTURADOS    
				     
 			SELECT ISNULL(I.Id_Cliente,C.ID_CLIENTE) As Id_Cliente, i.Id_Producto, Isnull(c.Id_Contrato,0) As Id_Contrato, count(*) As Cantidad
 							INTO Z_CONTRATOS_FACTURADOS
							FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T, Contratos O
									WHERE c.id_trans = i.id_trans 
											 AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
											 AND C.Id_Contrato = O.Id_Contrato
											 AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) 
											  or  (c.Id_Estado_Cbte <> 0 and c.Id_Estado_Cbte <> 3))
											 AND (T.Compromete_Factura = 1
 											 OR T.Compromete_Remitos = 1)
											 AND DATEPART(yy,i.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
											 AND DATEPART(mm,i.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
											 AND O.Id_Contrato = @pId_Contrato
											 GROUP BY ISNULL(I.Id_Cliente,C.ID_CLIENTE) , i.Id_Producto	, c.Id_Contrato 


			IF OBJECT_ID (N'Z_Productos_Facturados', N'U') IS NOT NULL
		       DROP TABLE Z_Productos_Facturados  

			SELECT L.Id_Cliente, I.Id_Producto
								INTO Z_Productos_Facturados
								FROM
								Clientes L, Cbtes_Items I, Cbtes C, Cbtes_Tipos CT
								WHERE L.Id_Cliente = I.Id_Cliente
								AND I.Id_Cliente = @Id_Cliente
								AND I.Id_Trans = C.Id_Trans 
								AND C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
								AND C.Id_Estado_Cbte NOT IN (0,3)
								AND CT.Compromete_Factura = 1
								AND DATEPART(yy,I.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
								AND DATEPART(mm,I.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
								GROUP BY L.Id_Cliente, I.Id_Producto

			SET @pFlag_Tabla_Temp = 1	
		END
	ELSE  ----IF @pFlag_Tabla_Temp = 0
	    BEGIN
			IF OBJECT_ID('Z_CONTRATOS_FACTURADOS') IS NULL
			BEGIN 
 				SELECT ISNULL(I.Id_Cliente,C.ID_CLIENTE) As Id_Cliente, i.Id_Producto, Isnull(c.Id_Contrato,0) As Id_Contrato, 0 As Cantidad
 						INTO Z_CONTRATOS_FACTURADOS
			  			FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T, Contratos O
			 			WHERE 1=0  
			END
	
	
			IF OBJECT_ID('Z_Productos_Facturados') IS NULL
			BEGIN 
 				SELECT I.Id_Cliente, I.Id_Producto
						INTO Z_Productos_Facturados
						FROM Cbtes_Items I 
						WHERE 1=0
			END	    
        END


	--INICIALIZO VARIABLES

	SELECT 
				@Id_Tipo_Cbte			= ISNULL(Id_Tipo_Cbte, ''),
				@Id_Cond_Pago			= ISNULL(Id_Cond_Pago, 0),
				@Id_Tipo_Con			= ISNULL(Id_Tipo_Con, 0),
				@Bonif_Contrato			= ISNULL(Porc_Bonif,0),
				@Imp_Bonif_Contrato		= ISNULL(Imp_Bonif,0),
				@Bonif					= 0,
				@Flag_Fact_Titular		= ISNULL(Flag_Fact_Titular, 0),
				@Id_Lista_Precio_Cont	= ISNULL(Id_Lista_Precio, 0)
				FROM Contratos 
				WHERE 
				Id_Contrato			= @pId_Contrato

	SELECT 
				@Id_Lista_Precio_Cli_Esp		= ISNULL(Id_Precio_Especial, 0),
				@Id_Lista_Precio_Cli			= ISNULL(Id_Lista_Precio, 0)
				FROM Clientes 
				WHERE 
				Id_Cliente			= @Id_Cliente

	IF ISNULL(@Id_Lista_Precio_Cli,0) <> 0			SET @Id_Lista_Precio = @Id_Lista_Precio_Cli	
	IF ISNULL(@Id_Lista_Precio_Cli_Esp,0) <> 0		SET @Id_Lista_Precio = @Id_Lista_Precio_Cli_Esp	
	IF ISNULL(@Id_Lista_Precio_Cont,0) <> 0			SET @Id_Lista_Precio = @Id_Lista_Precio_Cont	

	SET @Id_Producto_Bonif	= dbo.CF_xParam('Lote_Bonif_Prod')

	IF @Id_Producto_Bonif	= '' SET @Bonif = @Bonif_Contrato
	IF @Bonif_Contrato		<> 0 SET @Imp_Bonif_Contrato = 0

	IF(@Id_Cond_Pago = 0)
	BEGIN
		SET @Id_Cond_Pago = dbo.CF_xParam('Cond_pago_Lotes_Cont')
	END
	
	SELECT
				@Id_Moneda			= ISNULL(Id_Moneda, ''),
				@Compromete_Factura	= ISNULL(Compromete_Factura, 0),
				@Compromete_Remitos	= ISNULL(Compromete_Remitos, 0)
				FROM Cbtes_Tipos
				WHERE
				Id_Tipo_Cbte = @Id_Tipo_Cbte
	
	IF(@Id_Moneda = '')
	BEGIN
		SET @Id_Moneda = (dbo.CF_xParam('Moneda_Nacional'))
	END

	SELECT
				@Cotizacion		= ISNULL(Cotizacion, 1) 
				FROM Valores_Monedas 
				WHERE 
				Id_Moneda = @Id_Moneda

	SELECT 
				@Plazo_Venc		= ISNULL(Plazo_Venc, 0)
				FROM Cbtes_Cond_Pago
				WHERE
				Id_Cond_Pago = @Id_Cond_Pago

	SET @FechaVence = DATEADD(dd, @Plazo_Venc, @pFecha)

	SET @pFlag_Verif_Prod_Fact_x_Contrato = ISNULL((SELECT Flag_Verif_Prod_Fact_x_Contrato FROM Contratos_Tipos WHERE Id_Tipo_Con = @Id_Tipo_Con),0) -- 31/8

	/*===================================================================*/
	-- COMIENZO VALIDACION PARA LA VARIABLE ID_TIEMPO DENTRO DEL CONTRATO

	DECLARE @Periodicidad				CHAR(1)
	DECLARE @Cantidad_Per				INT
	DECLARE @Ult_Fecha_Fact_Contrato	DATETIME
	DECLARE @Prox_Fecha_Fact_Contrato	DATETIME

	IF(@pId_Tiempo <> '' OR (SELECT ISNULL(Tipo,'M') FROM Tab_Uni_Tiempo WHERE Id_Tiempo = @pId_Tiempo) <> 'M')
	BEGIN
		/*05/05/2022 Lo que interesa es la fecha en la cual se facturo, no el periodo*/
		SET @Ult_Fecha_Fact_Contrato = ISNULL(	(SELECT MAX(C.Fecha) 
												FROM CBTES_ITEMS I, CBTES C, CBTES_TIPOS T
												WHERE 
												I.Id_Trans = C.Id_Trans
												AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
												AND C.ID_CONTRATO = @pId_Contrato
												AND I.Id_Cliente = @Id_Cliente 
												AND C.Id_Estado_Cbte <> 3
												AND T.Compromete_Factura = 1
												)
											, '19000101')		
		
        SELECT 
					@Periodicidad = Tipo,
					@Cantidad_Per = Cantidad 
					FROM Tab_Uni_Tiempo
					WHERE 
					@pId_Tiempo = Id_Tiempo

		--- Si la periodicidad es en base a DIAS			
		IF(@Periodicidad = 'D')
		BEGIN
			SET @Prox_Fecha_Fact_Contrato = ISNULL((SELECT DATEADD(DAY,@Cantidad_Per,@Ult_Fecha_Fact_Contrato)), 0)
		END
		
		IF(@Periodicidad = 'M')
		BEGIN
			SET @Prox_Fecha_Fact_Contrato = ISNULL((SELECT DATEADD(MONTH,@Cantidad_Per,@Ult_Fecha_Fact_Contrato)), 0)
		END

		IF(@Periodicidad = 'A')
		BEGIN
			SET @Prox_Fecha_Fact_Contrato = ISNULL((SELECT DATEADD(YEAR,@Cantidad_Per,@Ult_Fecha_Fact_Contrato)), 0)
		END

		-- Valido que la fecha actual sea la permitida o posterior
		IF(@Prox_Fecha_Fact_Contrato > @pFecha)
		BEGIN
			RETURN 0
		END
	END

	/*===================================================================*/

	SELECT * INTO #ITEMS_CBTE FROM CBTES_ITEMS WHERE 1=0

	/*===================================================================*/

	/*3.1) Por Contratos_Tipos_Prod*/	
	IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.1) Por Contratos_Tipos_Prod'

	SET @ID_TRANS = 0

    DECLARE @Contratos_Tipos_Prod_cant INT

	SET @Contratos_Tipos_Prod_cant = (SELECT COUNT(*) 
									FROM Contratos_Tipos_Prod C, Productos P, Productos_TasaIva T
									WHERE
									C.Id_Tipo_Con = @Id_Tipo_Con
									AND C.Id_Tipo_Con <> 0
									AND C.Id_Producto <> ''
									AND C.Id_Producto = P.Id_Producto
									AND T.Id_Iva = P.Id_Iva)
	
    IF (@Contratos_Tipos_Prod_cant > 0)
	BEGIN
		DECLARE curContratoGenerarCbtes_ItemsXContratos_Tipos CURSOR FOR
					SELECT C.Id_Producto, ISNULL(C.Cantidad,0), ISNULL(T.Porc1,0), ISNULL(P.Flag_Mes_Desglo, 0)
								FROM Contratos_Tipos_Prod C, Productos P , Productos_TasaIva T
								WHERE
								C.Id_Tipo_Con = @Id_Tipo_Con
								AND C.Id_Tipo_Con <> 0
								AND C.Id_Producto <> ''
								AND C.Id_Producto = P.Id_Producto
								AND T.Id_Iva = P.Id_Iva

		OPEN curContratoGenerarCbtes_ItemsXContratos_Tipos
		FETCH NEXT FROM curContratoGenerarCbtes_ItemsXContratos_Tipos INTO @Id_Producto, @Cantidad, @Porc_Iva, @Flag_Mes_Desglo
		WHILE @@FETCH_STATUS = 0
		BEGIN
			/*
			22/07/2021:
			@CF_Produc_Precio_TipoRespuesta se utiliza en la llamada a la funcion: CF_Produc_Precio.
			Si @CF_Produc_Precio_TipoRespuesta = B CF_Produc_Precio retorna el Precio con la bonificacion aplicada, por lo tanto al grabar con CPJ_Cbtes_Fac_Generar_Item no se le envia @Bonif
			*/
			SET @CF_Produc_Precio_TipoRespuesta = 'B' 

			/*20/05/2020 Se empieza a utilizar CF_Produc_Precio en vez de CPJ_Produc_Precio.*/
			/*27/07/2021 De acuerdo a si tiene Porc_Iva o no graba Precio_Grav o Precio_Exen*/
			/*19/09/2021 Como funciona el sistema siempre hay que enviar el importe en Precio_Grav*/
	--		IF(@Porc_Iva > 0)
	--		BEGIN
				SET @Precio_Grav = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente, @pFecha_QA, @pId_Contrato, @Bonif/*Es la Bonif que tiene el contrato, si no se mandaria seria lo mismo ya que se envia el id_Contrato*/,  @CF_Produc_Precio_TipoRespuesta))
				SET @Precio_Exen = 0
	--		END
	--		ELSE
	--		BEGIN
	--			SET @Precio_Grav = 0
	--			SET @Precio_Exen = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente, @pFecha_QA, @pId_Contrato, @Bonif/*Es la Bonif que tiene el contrato, si no se mandaria seria lo mismo ya que se envia el id_Contrato*/,  @CF_Produc_Precio_TipoRespuesta))
	--		END

			IF (@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.1) @Id_Producto: ' + @Id_Producto + ' @Precio_Grav: ' + CONVERT(VARCHAR(20), @Precio_Grav) + ' @Precio_Exen: ' + CONVERT(VARCHAR(20), @Precio_Grav)
				PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Flag_Mes_Desglo: ' + CONVERT(VARCHAR(10), @Flag_Mes_Desglo) + '. @Cantidad: ' + CONVERT(VARCHAR(20), @Cantidad)
			END

			--22/07/2021 Se explicita por prueba de Facturacion por Lote en Ciudad donde el porcentaje de descuento esta grabado en "Contratos"
			IF(@CF_Produc_Precio_TipoRespuesta = 'B')
			BEGIN
				SET @Bonif = 0
			END

			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.1) @CF_Produc_Precio_TipoRespuesta: ' + @CF_Produc_Precio_TipoRespuesta

			IF(@Flag_Mes_Desglo = 1 AND @Cantidad > 1)
			BEGIN
				/*05/05/2022 Tiene que desglozar la cantidad por cada mes*/
				SET @Desglozar_Contador = 0
				WHILE (@Desglozar_Contador < @Cantidad)
				BEGIN
					SET @Desglozar_Fecha_QA		= dbo.CF_FOMONTH(DATEADD(MONTH, @Desglozar_Contador, @pFecha_QA))
					SET @Desglozar_Fecha_Venc	= dbo.CF_EOMONTH(@Desglozar_Fecha_QA)

					IF (@pModoDebug = 1)
					BEGIN
						PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Desglozar_Fecha_QA: ' + CONVERT(VARCHAR(10), @Desglozar_Fecha_QA, 112) + ' @Desglozar_Fecha_Venc: ' + CONVERT(VARCHAR(10), @Desglozar_Fecha_Venc, 112)
					END

					SET @JSON_Parametros_Stored_Invocado =	'{' +
															dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
															dbo.CF_Json_ParsearVariable('Cantidad', 1, 'DECIMAL(15,5)') + ',' +
															dbo.CF_Json_ParsearVariable('Fecha_QA', @Desglozar_Fecha_QA, 'DATETIME') + ',' +
															dbo.CF_Json_ParsearVariable('Fecha_Venc', @Desglozar_Fecha_Venc, 'DATETIME') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
															dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
															dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
															dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
															dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
															dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
															dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
															dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
															'}'

					DELETE @Result_Tabla_Stored_Invocado

					IF(@Compromete_Factura = 1)
					BEGIN
						IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(1)'
					
						INSERT INTO @Result_Tabla_Stored_Invocado
						EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado

					END

					IF(@Compromete_Remitos = 1)
					BEGIN
						IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(2)'

						INSERT INTO @Result_Tabla_Stored_Invocado
						EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
					END

					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item', 16,  1 )  
	
					SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado

					--Suma 1
					SET @Desglozar_Contador = @Desglozar_Contador + 1
				END
			END
			ELSE
			BEGIN		
				/*ELSE de IF(@Flag_Mes_Desglo = 1 AND @Cantidad > 1)*/
				SET @JSON_Parametros_Stored_Invocado =	'{' +
														dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
														dbo.CF_Json_ParsearVariable('Cantidad', @Cantidad, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_QA', @pFecha_QA, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_Venc', @pFecha_Venc, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
														dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
														dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
														dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
														'}'

				DELETE @Result_Tabla_Stored_Invocado

				IF (@Compromete_Factura = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(3)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
				END

				IF (@Compromete_Remitos = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(4)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
				END

				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item', 16,  1 )  
	
				SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
			END

			FETCH NEXT FROM curContratoGenerarCbtes_ItemsXContratos_Tipos INTO @Id_Producto, @Cantidad, @Porc_Iva, @Flag_Mes_Desglo
		END
		CLOSE curContratoGenerarCbtes_ItemsXContratos_Tipos
		DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Tipos
    END

	/*-------------------------------------------------------------------*/

	/*3.2) Por Contratos_Prod*/
	IF (@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.2) Por Contratos_Prod'
	END

	DECLARE curContratoGenerarCbtes_ItemsXContratos_Prod CURSOR FOR
				SELECT C.Id_Producto, ISNULL(C.Cantidad,0), ISNULL(T.Porc1,0), ISNULL(P.Flag_Mes_Desglo, 0)
							FROM Contratos_Prod C, Productos P , Productos_TasaIva T
							WHERE C.Id_Contrato = @pId_Contrato
							AND C.Flag_Facturable = 1
							AND C.Id_Producto <> ''
							AND C.Id_Producto = P.Id_Producto
							AND T.Id_Iva = P.Id_Iva

	OPEN curContratoGenerarCbtes_ItemsXContratos_Prod
	FETCH NEXT FROM curContratoGenerarCbtes_ItemsXContratos_Prod INTO @Id_Producto, @Cantidad, @Porc_Iva, @Flag_Mes_Desglo
	WHILE @@FETCH_STATUS = 0
	BEGIN
		/*
		22/07/2021:
		@CF_Produc_Precio_TipoRespuesta se utiliza en la llamada a la funcion:: CF_Produc_Precio.
		Si @CF_Produc_Precio_TipoRespuesta = B CF_Produc_Precio retorna el Precio con la bonificacion aplicada, por lo tanto al grabar con CPJ_Cbtes_Fac_Generar_Item no se le envia @Bonif
		*/
		SET @CF_Produc_Precio_TipoRespuesta = 'B' 

		/*20/05/2020 Se empieza a utilizar CF_Produc_Precio en vez de CPJ_Produc_Precio.*/
		/*27/07/2021 De acuerdo a si tiene Porc_Iva o no graba Precio_Grav o Precio_Exen*/
		/*19/09/2021 Como funciona el sistema siempre hay que enviar el importe en Precio_Grav*/
--		IF(@Porc_Iva > 0)
--		BEGIN
			SET @Precio_Grav = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente, @pFecha_QA, @pId_Contrato, @Bonif/*Es la Bonif que tiene el contrato, si no se mandaria seria lo mismo ya que se envia el id_Contrato*/,  @CF_Produc_Precio_TipoRespuesta))
			SET @Precio_Exen = 0
--		END
--		ELSE
--		BEGIN
--			SET @Precio_Grav = 0
--			SET @Precio_Exen = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente, @pFecha_QA, @pId_Contrato, @Bonif/*Es la Bonif que tiene el contrato, si no se mandaria seria lo mismo ya que se envia el id_Contrato*/,  @CF_Produc_Precio_TipoRespuesta))
--		END	

		IF (@pModoDebug = 1)
		BEGIN
			PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.2) @Id_Producto: ' + @Id_Producto + ' @Precio_Grav: ' + CONVERT(VARCHAR(15), @Precio_Grav) + ' @Precio_Exen: ' + CONVERT(VARCHAR(15), @Precio_Exen)
			PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Flag_Mes_Desglo: ' + CONVERT(VARCHAR(10), @Flag_Mes_Desglo) + '. @Cantidad: ' + CONVERT(VARCHAR(20), @Cantidad)
		END

		--22/07/2021 Se explicita por prueba de Facturacion por Lote en Ciudad donde el porcentaje de descuento esta grabado en "Contratos"
		IF(@CF_Produc_Precio_TipoRespuesta = 'B')
		BEGIN
			SET @Bonif = 0
		END
		IF @Id_Lista_Precio <> 0
		BEGIN
			SELECT @Cant_Cuotas = Cant_Cuotas FROM Prod_Listas_Precios WHERE Id_Lista_Precio = @Id_Lista_Precio 

			PRINT @Cant_Cuotas 
			IF ISNULL(@Cant_Cuotas,0) <> 0	SET @Cantidad = @Cant_Cuotas
		END 




		IF(@Flag_Mes_Desglo = 1 AND @Cantidad > 1)
		BEGIN
			/*05/05/2022 Tiene que desglozar la cantidad por cada mes*/
			SET @Desglozar_Contador = 0 ---Modificado 2/10/23
			WHILE (@Desglozar_Contador < @Cantidad)
			BEGIN
				SET @Desglozar_Fecha_QA		= dbo.CF_FOMONTH(DATEADD(MONTH, @Desglozar_Contador, @pFecha_QA))
				SET @Desglozar_Fecha_Venc	= dbo.CF_EOMONTH(@Desglozar_Fecha_QA)

				IF (@pModoDebug = 1)
				BEGIN
					PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Desglozar_Fecha_QA: ' + CONVERT(VARCHAR(10), @Desglozar_Fecha_QA, 112) + ' @Desglozar_Fecha_Venc: ' + CONVERT(VARCHAR(10), @Desglozar_Fecha_Venc, 112)
				END

				SET @JSON_Parametros_Stored_Invocado =	'{' +
														dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
														dbo.CF_Json_ParsearVariable('Cantidad', 1, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_QA', @Desglozar_Fecha_QA, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_Venc', @Desglozar_Fecha_Venc, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
														dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
														dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
														dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
														'}'
	
				DELETE @Result_Tabla_Stored_Invocado

				IF(@Compromete_Factura = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(5)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado					
					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ( @JSON_Parametros_Stored_Invocado , 16,  1 ) 
				END
 
				IF(@Compromete_Remitos = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(6)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Rem_Generar_Item @JSON_Parametros_Stored_Invocado
					IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar_Item  2', 16,  1 ) 
				END
 
				SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
 
				--Suma 1
				SET @Desglozar_Contador = @Desglozar_Contador + 1
			END
		END
		ELSE
		BEGIN
			/*ELSE de IF(@Flag_Mes_Desglo = 1 AND @Cantidad > 1)*/
			SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
													dbo.CF_Json_ParsearVariable('Cantidad', @Cantidad, 'DECIMAL(15,5)') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha_QA', @pFecha_QA, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha_Venc', @pFecha_Venc, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
													dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
													dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
													dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
													'}'
	

			DELETE @Result_Tabla_Stored_Invocado

			IF(@Compromete_Factura = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(7)'

				INSERT INTO @Result_Tabla_Stored_Invocado
				EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ( @JSON_Parametros_Stored_Invocado , 16,  1 ) 
			END

			IF(@Compromete_Remitos = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(8)'

				INSERT INTO @Result_Tabla_Stored_Invocado
				EXEC @Result_Stored_Invocado = CPJ_Cbtes_Rem_Generar_Item @JSON_Parametros_Stored_Invocado
				IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar_Item  2', 16,  1 ) 
			END
	
			SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
		END

		FETCH NEXT FROM curContratoGenerarCbtes_ItemsXContratos_Prod INTO @Id_Producto, @Cantidad, @Porc_Iva, @Flag_Mes_Desglo
	END
	CLOSE curContratoGenerarCbtes_ItemsXContratos_Prod
	DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Prod

	/*-------------------------------------------------------------------*/
	/*3.3) Por Clientes Integrantes Agrupados*/
	IF (@pModoDebug = 1)
	BEGIN
		PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.3) Por Clientes Integrantes Agrupados'
	END
	
	SET @Flag_Agru_Cli_Ref  = 0
	SET @Flag_Remitos		= 0
	SET @Id_Tipo_Cbte_Remito= ''

	IF(@Id_Tipo_Con > 0)
	BEGIN
		SELECT	
			@Flag_Agru_Cli_Ref	= ISNULL(Flag_Agru_Cli_Ref, 0),
			@Flag_Remitos		= ISNULL(Flag_Remitos, 0),
			@Id_Tipo_Cbte_Remito= ISNULL(Id_Tipo_Cbte_Remito, '')
			FROM Contratos_Tipos
			WHERE
			Id_Tipo_Con = @Id_Tipo_Con
	END 

	IF(@Flag_Agru_Cli_Ref = 1)
	BEGIN
		SET @Observacion_Incluye_Integ = ''

		DECLARE curContratoGenerarCbtes_ItemsXClientesIntAgrup CURSOR FOR
			SELECT DISTINCT CTInt.Id_Cliente, CPInt.Id_Producto, ISNULL(CPInt.Cantidad,0), ISNULL(TI.PORC1,0),ISNULL(CTInt.Porc_Bonif,0)
				FROM Contratos CTInt, Contratos_Prod CPInt, Productos P, Productos_TasaIva TI
				WHERE CTInt.Id_Contrato = CPInt.Id_Contrato
				AND CPInt.Id_Producto <> ''
				and CPInt.Id_Producto = P.Id_Producto
				AND CPInt.Flag_Facturable = 1
				and P.Id_Iva = TI.Id_Iva
				AND CTInt.Id_Tipo_Con = @Id_Tipo_Con
				AND CONVERT(DATE, CTInt.Fecha_Desde) <= CONVERT(DATE, @pFecha_QA)
				AND (CONVERT(DATE, CTInt.Fecha_Hasta) >= CONVERT(DATE, @pFecha_QA) OR CTInt.Fecha_Hasta IS NULL)
				AND CTInt.Id_Cliente IN (SELECT DISTINCT Id_Cliente FROM Clientes WHERE Id_Cliente_Ref = @Id_Cliente AND Fecha_Baja IS NULL)
				AND CTInt.Id_Cliente <> 0

		OPEN curContratoGenerarCbtes_ItemsXClientesIntAgrup
		FETCH NEXT FROM curContratoGenerarCbtes_ItemsXClientesIntAgrup INTO @Id_Cliente_Integ, @Id_Producto, @Cantidad, @Porc_Iva,@BonifContInt
		WHILE @@FETCH_STATUS = 0
		BEGIN

			IF(@Observacion_Incluye_Integ = '')
				SET @Observacion_Incluye_Integ = 'Incluye Socio: ' + CONVERT(VARCHAR(10), @Id_Cliente_Integ) 
			ELSE
				SET @Observacion_Incluye_Integ = @Observacion_Incluye_Integ + ', ' + CONVERT(VARCHAR(10), @Id_Cliente_Integ) 

			/*
			22/07/2021:
			@CF_Produc_Precio_TipoRespuesta se utiliza en la llamada a la funcion: CF_Produc_Precio.
			Si @CF_Produc_Precio_TipoRespuesta = B CF_Produc_Precio retorna el Precio con la bonificacion aplicada, por lo tanto al grabar con CPJ_Cbtes_Fac_Generar_Item no se le envia @Bonif
			*/
			SET @CF_Produc_Precio_TipoRespuesta = 'B' 

			/*20/05/2020 Se empieza a utilizar CF_Produc_Precio en vez de CPJ_Produc_Precio.*/
			/*27/07/2021 De acuerdo a si tiene Porc_Iva o no graba Precio_Grav o Precio_Exen*/
			/*19/09/2021 Como funciona el sistema siempre hay que enviar el importe en Precio_Grav*/
--			IF(@Porc_Iva > 0)
--			BEGIN
				SET @Precio_Grav = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente_Integ, @pFecha_QA, @pId_Contrato, 0 /*Se envia el contrato*/,  @CF_Produc_Precio_TipoRespuesta))
				SET @Precio_Exen = 0
--			END
--			ELSE
--			BEGIN
--				SET @Precio_Grav = 0
--				SET @Precio_Exen = (dbo.CF_Produc_Precio(@Id_Producto, @Id_Cliente_Integ, @pFecha_QA, @pId_Contrato, 0 /*Se envia el contrato*/,  @CF_Produc_Precio_TipoRespuesta))
--			END	

			--22/07/2021 Se explicita por prueba de Facturacion por Lote en Ciudad donde el porcentaje de descuento esta grabado en "Contratos"
			IF(@CF_Produc_Precio_TipoRespuesta = 'B') SET @Bonif = 0

			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.3) @Id_Cliente_Integ: '+ CONVERT(VARCHAR(10), @Id_Cliente_Integ) + ' @Id_Producto: ' + @Id_Producto + ' @Precio_Grav: ' + CONVERT(VARCHAR(10), @Precio_Grav) + ' @Precio_Exen: ' + CONVERT(VARCHAR(10), @Precio_Grav)

			SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
													dbo.CF_Json_ParsearVariable('Cantidad', @Cantidad, 'DECIMAL(15,5)') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha_QA', @pFecha_QA, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha_Venc', @pFecha_Venc, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente_Integ, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Bonif', @BonifContInt, 'DECIMAL(5,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
													dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
												    dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
												    dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
													dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
						                            dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
													'}'

			DELETE @Result_Tabla_Stored_Invocado

			IF(@Compromete_Factura = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(9)'

				INSERT INTO @Result_Tabla_Stored_Invocado
				EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
		    	IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item 3', 16,  1 ) 
			END

			IF(@Compromete_Remitos = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(10)'

				INSERT INTO @Result_Tabla_Stored_Invocado
				EXEC @Result_Stored_Invocado = CPJ_Cbtes_Rem_Generar_Item @JSON_Parametros_Stored_Invocado
		    	IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar_Item 3', 16,  1 ) 
			END

			SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado

			FETCH NEXT FROM curContratoGenerarCbtes_ItemsXClientesIntAgrup INTO @Id_Cliente_Integ, @Id_Producto, @Cantidad, @Porc_Iva, @BonifContInt
		END
		CLOSE curContratoGenerarCbtes_ItemsXClientesIntAgrup
		DEALLOCATE curContratoGenerarCbtes_ItemsXClientesIntAgrup


	END
	/*-------------------------------------------------------------------*/
		
	/*3.4) Items de remitos propios*/
	IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.4) Items de remitos propios'

	IF(@Flag_Remitos = 1)
	BEGIN
	    CREATE TABLE #Int_remitos (Id_Cliente INT)
		IF @Flag_Agru_Cli_Ref =  1 
			INSERT INTO #Int_remitos SELECT Id_Cliente FROM Clientes WHERE Id_Cliente_Ref = @Id_Cliente	
        ELSE
			INSERT INTO #Int_remitos SELECT Id_Cliente FROM Clientes WHERE Id_Cliente = @Id_Cliente	

		IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.4) Entro en flag remitos'

		DECLARE curContratoGenerarCbtes_ItemsXRemitosPropiosTr CURSOR FOR
					SELECT DISTINCT CB.Id_Trans
							FROM Cbtes CB, Cbtes_Items CI, Cbtes_Tipos CT
							WHERE
							CB.Id_Trans = CI.Id_Trans
							AND CI.Id_Producto <> ''
							AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
							AND CT.Compromete_Remitos IN (1)
							AND CB.Id_Estado_Cbte = 1
							AND CONVERT(DATE, CB.Fecha) >= CONVERT(DATE, @pFecha_Rem_Desde)
							AND CONVERT(DATE, CB.Fecha) <= CONVERT(DATE, @pFecha_Rem_Hasta)
							AND (CB.Id_Cliente = @Id_Cliente /*No es por Cbtes_Items sino por la cabecera*/
									OR CB.Id_Cliente IN (SELECT Id_Cliente FROM #Int_remitos))

		OPEN curContratoGenerarCbtes_ItemsXRemitosPropiosTr
		FETCH NEXT FROM curContratoGenerarCbtes_ItemsXRemitosPropiosTr INTO @Id_Trans_Remito
		WHILE @@FETCH_STATUS = 0
		BEGIN
		    IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.4) Entro cursor remitos'
			DECLARE curContratoGenerarCbtes_ItemsXRemitosPropios CURSOR FOR
						SELECT CI.Id_Producto, CI.Cantidad, CI.Fecha_QA, CI.Fecha_Venc, CI.Precio_Grav, CI.Precio_Exen, CI.Bonif, CI.Porc_Iva, CI.Id_Cliente
							FROM  Cbtes_Items CI
							WHERE CI.Id_Trans = @Id_Trans_Remito

			OPEN curContratoGenerarCbtes_ItemsXRemitosPropios
			FETCH NEXT FROM curContratoGenerarCbtes_ItemsXRemitosPropios INTO @Id_Producto, @Cantidad, @Fecha_QA, @Fecha_Venc, @Precio_Grav, @Precio_Exen, @Bonif, @Porc_Iva, @Id_Cliente_Remito
			WHILE @@FETCH_STATUS = 0
			BEGIN

				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '3.4) @Id_Producto: ' + @Id_Producto + ' @Precio_Grav: ' + CONVERT(VARCHAR(20), @Precio_Grav) + ' @Precio_Exen: ' + CONVERT(VARCHAR(20), @Precio_Grav)

				SET @JSON_Parametros_Stored_Invocado =	'{' +
														dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto, 'VARCHAR(14)') + ',' +
														dbo.CF_Json_ParsearVariable('Cantidad', @Cantidad, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_QA', @Fecha_QA, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Fecha_Venc', @Fecha_Venc, 'DATETIME') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente_Remito, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
														dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
														dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
													    dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
														dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
													    dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
														dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
						                                dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
														'}'

				DELETE @Result_Tabla_Stored_Invocado

				IF(@Compromete_Factura = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(11)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
		    		IF ISNULL(@Result_Stored_Invocado, 0) <> 0  RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item 4', 16,  1 ) 
				END

				IF(@Compromete_Remitos = 1)
				BEGIN
					IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(12)'

					INSERT INTO @Result_Tabla_Stored_Invocado
					EXEC @Result_Stored_Invocado = CPJ_Cbtes_Rem_Generar_Item @JSON_Parametros_Stored_Invocado
		  	    	IF ISNULL(@Result_Stored_Invocado, 0) <> 0  RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar_Item 4', 16,  1 ) 
			    END
	
				SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado

				FETCH NEXT FROM curContratoGenerarCbtes_ItemsXRemitosPropios INTO  @Id_Producto, @Cantidad, @Fecha_QA, @Fecha_Venc, @Precio_Grav, @Precio_Exen, @Bonif, @Porc_Iva,@Id_Cliente_Remito
			END
			CLOSE curContratoGenerarCbtes_ItemsXRemitosPropios
			DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropios

			UPDATE Cbtes SET Id_Estado_Cbte = 2 /*Completo*/ WHERE Id_Trans = @Id_Trans_Remito
			FETCH NEXT FROM curContratoGenerarCbtes_ItemsXRemitosPropiosTr INTO @Id_Trans_Remito
		END
		CLOSE curContratoGenerarCbtes_ItemsXRemitosPropiosTr
		DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropiosTr
	END

	/*----APLICO LA BONIFICACION DEL CONTRATO ---*/
	/*Ingresa por aca por que existe un producto de Bonificacion que se carga por Parametro @Id_Producto_Bonif = dbo.CF_xParam('Lote_Bonif_Prod')*/
	IF @Bonif_Contrato <> 0 or @Imp_Bonif_Contrato <> 0
	   BEGIN
	       
	       IF @Id_Producto_Bonif <> ''
		      BEGIN
		    	   	SET @TotalCbte =  ISNULL((SELECT SUM(Imp_Gravado) FROM #ITEMS_CBTE ),0)
					IF @Bonif_Contrato <> 0
			             --SET @Precio_Grav = @TotalCbte * (1-(@Bonif_Contrato/100)) *-1
			             -- Se Modifica el calculo porque estaba Bonificando el total del comprobante en Lugar de multiplicar el porcentaje de bonif`por -1
			             SET @Precio_Grav = @TotalCbte * (@Bonif_Contrato/100)  *-1 
                    ELSE
				         SET @Precio_Grav = @Imp_Bonif_Contrato *-1

					SET @Cantidad = 1

		            SET @JSON_Parametros_Stored_Invocado =	'{' +
												dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Producto', @Id_Producto_Bonif, 'VARCHAR(14)') + ',' +
												dbo.CF_Json_ParsearVariable('Cantidad', @Cantidad, 'DECIMAL(15,5)') + ',' +
												dbo.CF_Json_ParsearVariable('Fecha_QA', @pFecha_QA, 'DATETIME') + ',' +
												dbo.CF_Json_ParsearVariable('Fecha_Venc', @pFecha_Venc, 'DATETIME') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
											    dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
												dbo.CF_Json_ParsearVariable('Bonif', @Bonif, 'DECIMAL(5,2)') + ',' +
												dbo.CF_Json_ParsearVariable('Porc_Iva', @Porc_Iva, 'DECIMAL(5,2)') + ',' +
												dbo.CF_Json_ParsearVariable('Precio_Grav', @Precio_Grav, 'DECIMAL(15,5)') + ',' +
												dbo.CF_Json_ParsearVariable('Precio_Exen', @Precio_Exen, 'DECIMAL(15,5)') + ',' +
												dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
												dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
												dbo.CF_Json_ParsearVariable('Flag_Verif_Prod_Fact_x_Contrato', @pFlag_Verif_Prod_Fact_x_Contrato, 'TINYINT') + ',' +
						                        dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
												'}'
	

					DELETE @Result_Tabla_Stored_Invocado

					IF(@Compromete_Factura = 1)
					BEGIN
						IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar_Item(13)'

						INSERT INTO @Result_Tabla_Stored_Invocado
						EXEC @Result_Stored_Invocado = CPJ_Cbtes_Fac_Generar_Item @JSON_Parametros_Stored_Invocado
		    			IF ISNULL(@Result_Stored_Invocado, 0) <> 0  RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar_Item 5', 16,  1 ) 
					END 
					SET @Bonif_Contrato  = 0 
            END

     END
	/*-------------------------------------------------------------------*/

	IF @pIncl_Cbtes_Cero = 1 
        SET @TotalCbte = 1
	ELSE
		SET @TotalCbte =  (SELECT SUM(Imp_Final) FROM #ITEMS_CBTE )

	IF EXISTS (SELECT 1 FROM #ITEMS_CBTE ) AND @TotalCbte <> 0
	BEGIN

			/*2) CPJ_Cbtes_Fac_Generar*/
			IF (@pModoDebug = 1)
			BEGIN
				PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '2) CPJ_Cbtes_Fac_Generar'
				PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Flag_Fact_Titular: ' + CONVERT(VARCHAR(10), @Flag_Fact_Titular)
			END

			--25/03/2021 Se agrega por Ticket 22594
			IF(@Flag_Fact_Titular = 1)
			BEGIN
				SELECT	@Id_Cliente_Ref = ISNULL(Id_Cliente_Ref,0) FROM Clientes WHERE Id_Cliente = @Id_Cliente
				IF (@Id_Cliente_Ref = 0) SET @Id_Cliente_Ref = @Id_Cliente
			END
			ELSE
				SET @Id_Cliente_Ref = @Id_Cliente

			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '@Id_Cliente_Ref: ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref)

			SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
													dbo.CF_Json_ParsearVariable('Fecha', @pFecha, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('FechaVence', @FechaVence, 'DATETIME') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente_Ref, 'INT') + ',' +			--25/03/2021 Se cambia por Ticket 22594
													dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_contrato, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Tipo_Cbte', @Id_Tipo_Cbte, 'CHAR(4)') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Cond_Pago', @Id_Cond_Pago, 'SMALLINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Moneda', @Id_Moneda, 'CHAR(3)') + ',' +
													dbo.CF_Json_ParsearVariable('Cotizacion', @Cotizacion, 'DECIMAL(12,4)') + ',' +
													dbo.CF_Json_ParsearVariable('Bonif_Contrato', @Bonif_Contrato, 'DECIMAL(5,2)') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_Contrato, 'INT') + ',' + 
													dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Lista_Precio', @Id_Lista_Precio, 'INT') + ',' +
												    dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Tiempo', @pId_Tiempo, 'CHAR(3)') + 
													'}'

			DELETE @Result_Tabla_Stored_Invocado

			IF(@Compromete_Factura = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Generar'

				INSERT INTO @Result_Tabla_Stored_Invocado  EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Generar @JSON_Parametros_Stored_Invocado
        		IF ISNULL(@Result_Stored_Invocado, 0) <> 0  RAISERROR ('Error when calling CPJ_Cbtes_Fac_Generar', 16,  1 ) 
			END

			IF(@Compromete_Remitos = 1)
			BEGIN
				IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rem_Generar'
	    			
				INSERT INTO @Result_Tabla_Stored_Invocado  EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rem_Generar @JSON_Parametros_Stored_Invocado
        		IF ISNULL(@Result_Stored_Invocado, 0) <> 0  RAISERROR ('Error when calling CPJ_Cbtes_Rem_Generar', 16,  1 ) 
			END

			SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado
			SET @Id_Trans = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@rta_JSON_Stored_Invocado,'Id_Trans')), 0)

			IF @Id_Trans = 0  RAISERROR ('Id_trans can not be zero.', 16,  1 )    /*El CPJ_Cbtes_Fac_Generarv debera devolver el SELECT con el error*/
	
			/*===================================================================*/

			/*3) GENERO LOS ITEMS DE LOS CBTES DE #Items_Cbtes*/

			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '#Items_Cbtes'

			UPDATE #ITEMS_CBTE SET ID_TRANS = @Id_Trans
			INSERT INTO CBTES_ITEMS SELECT * FROM #ITEMS_CBTE

			/*-------------------------------------------------------------------*/

		/*4) CPJ_Cbtes_Fac_Fin*/
		IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + '4) Por CPJ_Cbtes_Fac_Fin'

		SET @JSON_Parametros_Stored_Invocado =	'{' +
												dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
												dbo.CF_Json_ParsearVariable('Observacion_Incluye_Integ', @Observacion_Incluye_Integ, 'VARCHAR(8000)') + ',' +
										        dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', @pFlag_Tabla_Temp, 'TINYINT') + ',' +											
												dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans, 'INT') + 
												dbo.CF_Json_ParsearVariable('Omitir_Result_OK', 1, 'TINYINT') + 
												'}'

		DELETE @Result_Tabla_Stored_Invocado

		IF(@Compromete_Factura = 1)
		BEGIN
			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Fac_Fin'

			--INSERT INTO @Result_Tabla_Stored_Invocado          --esta comentado porque sino da error de NESTED INSERT EXEC ....09/08/2022
			EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Fac_Fin @JSON_Parametros_Stored_Invocado
			IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Fac_Fin', 16,  1 ) 
		END

		IF(@Compromete_Remitos = 1)
		BEGIN
			IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'CPJ_Cbtes_Rem_Fin'

			INSERT INTO @Result_Tabla_Stored_Invocado    --esta comentado porque sino da error de NESTED INSERT EXEC ....09/08/2022
			EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Rem_Fin @JSON_Parametros_Stored_Invocado
     		IF ISNULL(@Result_Stored_Invocado, 0) <> 0 RAISERROR ('Error when calling CPJ_Cbtes_Rem_Fin ', 16,  1 )
 		END

    	SELECT TOP 1 @rta_JSON_Stored_Invocado = ErrorMessage FROM @Result_Tabla_Stored_Invocado

		SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('Id_Trans', ISNULL(@Id_Trans,0), 'INT') +
								',' + dbo.CF_Json_ParsearVariable('Id_Trans_Remito', ISNULL(@Id_Trans_Remito,0), 'INT') +
								'}'

       
    END
	ELSE   --no genero items por contrato facturado
	BEGIN

		SET @rtaMsjStored		=	'{"Resultado":"Comprobante sin items, o ya facturado, o el total es cero "' +
									' , ' + dbo.CF_Json_ParsearVariable('Id_Contrato', @pId_Contrato, 'INT') +
									'}'
		SET @rtaErrorStored		= 899					 
	END


	/*===================================================================*/	
	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	

	IF (@pModoDebug = 1) PRINT CONVERT(VARCHAR(23), GETDATE(), 121) + ': ' + 'Fin Stored Procedure: CPJ_Contrato_Facturar'

    IF @pOmitir_Resultado_OK = 0
    	SELECT	 @rtaErrorStored AS ErrorNumber 
		    	,0				AS ErrorSeverity  
			    ,0				AS ErrorState 
		    	,0				AS ErrorProcedure  
		     	,@Id_Trans		AS ErrorLine		
		    	,@rtaMsjStored	AS ErrorMessage


	IF OBJECT_ID('tempdb..#ITEMS_CBTE','U') IS NOT NULL  DROP TABLE  #ITEMS_CBTE
END TRY  



BEGIN CATCH  
 

	IF EXISTS (SELECT 1 FROM @Result_Tabla_Stored_Invocado) SELECT * FROM @Result_Tabla_Stored_Invocado

    EXECUTE usp_GetErrorInfo

	IF RTRIM(LTRIM(ISNULL(@pLote,''))) <> '' AND ISNULL(@Id_Trans,0) <> 0 AND ISNULL(@pRegistrar_Errores,0) <> 0
	BEGIN
		DECLARE @Cbtes_Lotes_Errores_Item TINYINT
		SET @Cbtes_Lotes_Errores_Item = ISNULL(  (SELECT MAX(Item) FROM Cbtes_Lotes_Errores WHERE Lote = @pLote) ,0 ) + 1
		INSERT INTO Cbtes_Lotes_Errores (Lote,Item,Id_Trans,Id_Cliente,Descripcion)
			VALUES (@pLote,@Cbtes_Lotes_Errores_Item,@Id_Trans,ISNULL(@Id_Cliente,0),
					'ERROR_NUMBER: '+ CONVERT(VARCHAR(10),ERROR_NUMBER()) +
					'ERROR_LINE: '+ CONVERT(VARCHAR(10),ERROR_LINE()) +
					'ERROR_MESSAGE: '+ CONVERT(VARCHAR(8000),ERROR_MESSAGE() )

			  )

	END

	IF @pFlagUsarTrans <> 0 ROLLBACK

	---------------------------------------------------------------------------------------
	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXContratos_Tipos') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Tipos		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXContratos_Tipos') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXContratos_Tipos
	   DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Tipos		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXContratos_Prod') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Prod		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXContratos_Prod') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXContratos_Prod
	   DEALLOCATE curContratoGenerarCbtes_ItemsXContratos_Prod		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXClientesIntAgrup') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXClientesIntAgrup		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXClientesIntAgrup') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXClientesIntAgrup
	   DEALLOCATE curContratoGenerarCbtes_ItemsXClientesIntAgrup		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropios') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropios		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropios') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXRemitosPropios
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropios		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropios') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropios		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropios') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXRemitosPropios
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropios		 
	END
	---------------------------------------------------------------------------------------

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropiosTr') ) = -1
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropiosTr		 

	IF (SELECT CURSOR_STATUS('global','curContratoGenerarCbtes_ItemsXRemitosPropiosTr') ) = 1
	BEGIN
	   CLOSE curContratoGenerarCbtes_ItemsXRemitosPropiosTr
	   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropiosTr		 
	END
	---------------------------------------------------------------------------------------
    IF OBJECT_ID('tempdb..#ITEMS_CBTE','U') IS NOT NULL  DROP TABLE  #ITEMS_CBTE
	IF OBJECT_ID('tempdb..#Int_remitos','U') IS NOT NULL  DROP TABLE  #Int_remitos
	RETURN 9999
END CATCH

RETURN 0

/*
DECLARE @Param VARCHAR(5000) --51966
SET @Param = '{' +
			'"FlagUsarTrans":"0",' +
			'"ModoDebug":"1",' +
			'"Omitir_Resultado_Ok":"0",' +
			'"Id_Tiempo":"",' + 
			'"Refacturar":"1",' +
			'"Id_Contrato":"54303"' +
			'"Id_Usuario":"-1",' +
			'"Fecha":"20241001"' +
			'"Lote":"x1",' +
			'"Fecha_QA":"20241001",' +
			'"Fecha_Venc":"20241030",' +
			'"Fecha_Rem_Desde":"20241001",' +
			'"Fecha_Rem_Hasta":"20241031",' +
			'"Registrar_Errores":"1",' +
			'"Flag_Tabla_Temp":"0",' +
			'"Incl_Cbtes_Cero":"1",' +
			'}'

EXEC [CPJ_Contrato_Facturar] @Param

select * from cbtes where id_contrato = 54303
select * from z_vic

*/
